#!/bin/sh
echo "Game Name: $1"

echo "Copying the Game"
mkdir -p "appimage/usr/share/instead/games/"
cp -R /game/ "appimage/usr/share/instead/games/$1/"
cd "appimage/usr/share/instead/games/$1/"
echo "Preparing the Game Files"
build/appimage/run.sh || exit $?
cd -

echo "Modifying AppRun script"
sed "s/{game}/$1/" /tools/AppRunTemplate.sh > /tools/AppRun.sh
chmod +x /tools/AppRun.sh
cat /tools/AppRun.sh

echo "Building AppImage"
/tools/linuxdeploy-x86_64.AppImage --appdir appimage --desktop-file "appimage/$1.desktop" --custom-apprun /tools/AppRun.sh --executable appimage/usr/bin/sdl-instead --output appimage || exit $?
cp *.AppImage /game/build/appimage
