#!/bin/sh

if [ "$1" ]; then
    GAMEDIR="$1"
fi
if [ ! "$GAMEDIR" ]; then
    GAMEDIR=`pwd`
fi

echo "Working with game directory \"$GAMEDIR\""

if [ "$2" ]; then
    OUTPUTDIR="$2"
fi
if [ ! "$OUTPUTDIR" ]; then
    OUTPUTDIR=`dirname "$(realpath $0)"`
fi

DATADIR="`dirname "$(realpath $0)"`/data"
EXTRASDIR="`dirname "$(realpath $0)"`/../../extras"

# VERSION="1.0.0-beta1"  # TODO have a single source of truth for version

VERSION=$(grep -oP "^\-\- \\\$Version:\\s*\K.*?(?=\\\$?\$)" "$GAMEDIR/main3.lua")

echo "Preparing Game Files"
TEMPDIR=`mktemp -d` || exit $?
cp -r "$GAMEDIR" "$TEMPDIR"
cd "$TEMPDIR/a_dragon_and_the_tower"
rm extractor.lua
rm .hgignore
rm -r .hg
cd -

if [ ! "$NO_APPIMAGE_64" ] || [ ! "$NO_APPIMAGE_32" ]; then
    mkdir -p "$TEMPDIR/a_dragon_and_the_tower/build/appimage"
    cp -r "$DATADIR/appimage/." "$TEMPDIR/a_dragon_and_the_tower/build/appimage"
fi

if [ ! "$NO_APPIMAGE_64" ]; then
    echo "Building x86_64 AppImage"
    # TODO reuse premade temporary directory
    docker create --name adatt-appimage-x86_64 crew-build-instead-3.5.1-appimage-x64 a_dragon_and_the_tower
    sleep 5
    docker cp "$TEMPDIR/a_dragon_and_the_tower/." adatt-appimage-x86_64:/game
    docker start -a adatt-appimage-x86_64
    docker cp adatt-appimage-x86_64:/game/build/appimage/A_Dragon_and_the_Tower-x86_64.AppImage "$OUTPUTDIR/A_Dragon_and_the_Tower-$VERSION-x86_64.AppImage"
    docker rm adatt-appimage-x86_64
fi

if [ ! "$NO_APPIMAGE_32" ]; then
    echo "Building x86 AppImage"
    # TODO reuse premade temporary directory
    docker create --name adatt-appimage-x86 crew-build-instead-3.5.1-appimage-x86 a_dragon_and_the_tower 
    sleep 5
    docker cp "$TEMPDIR/a_dragon_and_the_tower/." adatt-appimage-x86:/game
    docker start -a adatt-appimage-x86
    docker cp adatt-appimage-x86:/game/build/appimage/A_Dragon_and_the_Tower-i386.AppImage "$OUTPUTDIR/A_Dragon_and_the_Tower-$VERSION-i386.AppImage"
    docker rm adatt-appimage-x86
fi

if [ ! "$NO_APPIMAGE_64" ] || [ ! "$NO_APPIMAGE_32" ]; then
    rm -r "$TEMPDIR/a_dragon_and_the_tower/build"
fi

if [ ! "$NO_INNOSETUP" ]; then
    echo "Building Windows setup"
    docker create --name adatt-innosetup crew-build-innosetup a_dragon_and_the_tower
    sleep 5
    docker cp "$EXTRASDIR/instead-3.5.1" adatt-innosetup:/data/instead-3.5.1
    docker cp "$GAMEDIR" adatt-innosetup:/data/a_dragon_and_the_tower
    sed "s/%VERSION%/$VERSION/g" "$DATADIR/innosetup/template.iss" > "$DATADIR/innosetup/windows.iss"
    docker cp "$DATADIR/innosetup/." adatt-innosetup:/data
    rm "$DATADIR/innosetup/windows.iss"
    docker start -a adatt-innosetup
    docker cp adatt-innosetup:/data/Output/A_Dragon_and_the_Tower-$VERSION.exe "$OUTPUTDIR/A_Dragon_and_the_Tower-$VERSION.exe"
    docker rm adatt-innosetup
fi

if [ ! "$NO_INNOSETUP95" ]; then
    echo "Building Windows 9x setup"
    docker create --name adatt-innosetup-95 crew-build-innosetup-95 a_dragon_and_the_tower
    sleep 5
    docker cp "$EXTRASDIR/instead-sdl1-i486" adatt-innosetup-95:/data/instead-3.5.1
    docker cp "$GAMEDIR" adatt-innosetup-95:/data/a_dragon_and_the_tower
    sed "s/%VERSION%/$VERSION/g" "$DATADIR/innosetup95/template.iss" > "$DATADIR/innosetup95/windows.iss"
    docker cp "$DATADIR/innosetup95/." adatt-innosetup-95:/data
    rm "$DATADIR/innosetup95/windows.iss"
    docker start -a adatt-innosetup-95
    docker cp adatt-innosetup-95:/data/Output/A_Dragon_and_the_Tower-$VERSION.exe "$OUTPUTDIR/A_Dragon_and_the_Tower-$VERSION-9x.exe"
    docker rm adatt-innosetup-95
fi

if [ ! "$NO_WIN32_ZIP" ]; then
    echo "Building Windows zip file"
    INSTEADDIR=`mktemp -d` || exit $?
    cp -r "$EXTRASDIR/instead-3.5.1/." "$INSTEADDIR/a_dragon_and_the_tower"
    cd "$INSTEADDIR/a_dragon_and_the_tower"
    rm -r games/*
    rm -r doc
    rm setup.iss
    rm -r icon
    rm -r themes/arctic
    rm -r themes/bluesteel
    rm -r themes/book
    rm -r themes/clearlooks
    rm -r themes/fantasy
    rm -r themes/mobile
    rm -r themes/wide
    mkdir games/a_dragon_and_the_tower
    mkdir appdata
    echo "standalone=1\ngame=a_dragon_and_the_tower" > appdata/profile
    cp -r "$TEMPDIR/a_dragon_and_the_tower" games/
    cd -
    cd "$INSTEADDIR"
    zip -rX "$OUTPUTDIR/A_Dragon_and_the_Tower-$VERSION-win32.zip" a_dragon_and_the_tower
    cd -
    rm -r $INSTEADDIR
fi

if [ ! "$NO_WIN9X_ZIP" ]; then
    echo "Building Windows 9X zip file"
    INSTEADDIR=`mktemp -d` || exit $?
    cp -r "$EXTRASDIR/instead-sdl1-i486/." "$INSTEADDIR/a_dragon_and_the_tower"
    cd "$INSTEADDIR/a_dragon_and_the_tower"
    rm -r games/*
    rm -r doc
    rm setup.iss
    rm -r icon
    rm -r themes/arctic
    rm -r themes/bluesteel
    rm -r themes/book
    rm -r themes/clearlooks
    rm -r themes/fantasy
    rm -r themes/mobile
    rm -r themes/wide
    mkdir games/a_dragon_and_the_tower
    mkdir appdata
    echo "standalone=1\ngame=a_dragon_and_the_tower" > appdata/profile
    cp -r "$TEMPDIR/a_dragon_and_the_tower" games/
    cd -
    cd "$INSTEADDIR"
    zip -rX "$OUTPUTDIR/A_Dragon_and_the_Tower-$VERSION-win32-9x.zip" a_dragon_and_the_tower
    cd -
    rm -r $INSTEADDIR
fi

if [ ! "$NO_ZIP" ]; then
    echo "Building cross-platform zip file"
    cd $TEMPDIR
    zip -rX "$OUTPUTDIR/A_Dragon_and_the_Tower-$VERSION.zip" ./
    cd -
fi

rm -r $TEMPDIR
